﻿/*
Run this script to update the MET/CONNECT database from 3.2.0 to 3.3.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.1.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.1.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.2.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.2.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- No need to process if we have a 3.3.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = 'BEAEC660-EEEE-4DDE-BAD1-A4A977CB9A8E' )
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');


	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[vw_METCONNECT_RESULTS]'
		DROP VIEW [dbo].[vw_METCONNECT_RESULTS]
	END

	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NULL
	BEGIN
	PRINT N'Creating [dbo].[vw_METCONNECT_RESULTS]'

		EXEC sp_executesql N'

	/****************************************************************
		vw_METCONNECT_RESULTS
		(C) 2019-21 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		11/06/2019  MM      Initial development
		11/25/2019  MM      Add cFunctionSelectCode
		11/23/2020  MM      Add Test Step
		02/23/2021  MM      Add Upper and Lower Limit
		03/05/2021  AC      Add FixedQuantity and VariableQuantity
	*****************************************************************/
	CREATE VIEW [dbo].[vw_METCONNECT_RESULTS]
	AS
		SELECT
			csr.nCallSheetResultUID AS [ResultKey],
			p.nPointUID AS [PointKey],
			p.nPointOrdinal AS [Ordinal],
			p.cPointDescription AS [Description],
			p.cFunctionSelectCode AS [FSC],
			p.cRemarks AS [Remarks],
			p.cPointPassFailStatus AS [Status],
			ISNULL([dbo].[udf_get_formattedValue](p.nCardinalPoint, p.nCardinalPointFormatUID),'''') AS [CardinalPoint],
			up3.cUnitSymbol AS [CardinalPointUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nReference, p.nReferenceFormatUID),'''') AS [Reference],
			up2.cUnitSymbol AS [ReferenceUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nUUT, p.nUUTFormatUID),'''') AS [Dut],
			up1.cUnitSymbol AS [DutUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nError, tol.nErrorFormatUID),'''') AS [Error],
			utol1.cUnitSymbol AS [ErrorUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID),'''') AS [ToleranceNegative],
			utol5.cUnitSymbol AS [ToleranceNegativeUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID),'''') AS [TolerancePositive],
			utol6.cUnitSymbol AS [TolerancePositiveUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID),'''') AS [GuardbandLowerLimit],
			upun18.cUnitSymbol AS [GuardbandLowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID),'''') AS [GuardbandUpperLimit],
			upun19.cUnitSymbol AS [GuardbandUpperLimitUnit],
			ISNULL(p.cPointPassFailStatus, '''') AS [PointPassFail],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID),'''') AS [ExpandedUncertainty],
			upun3.cUnitSymbol AS [ExpandedUncertaintyUnit],
			ISNULL(pes.cField009,'''') AS [TestStep],
			ISNULL([dbo].[udf_get_formattedValue](pun.nLowerLimit, pun.nLowerLimitFormatUID),'''') AS [LowerLimit],
			upun1.cUnitSymbol AS [LowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUpperLimit, pun.nUpperLimitFormatUID),'''') AS [UpperLimit],
			upun2.cUnitSymbol AS [UpperLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField010, pen.nField010FormatUID),'''') AS [FixedQuantity],
			upen1.cUnitSymbol AS [FixedQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField029, pen.nField029FormatUID),'''') AS [VariableQuantity],
			upen2.cUnitSymbol AS [VariableQuantityUnit]
		FROM
			[dbo].[CallSheetResults] csr
			INNER JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[Units] up1 ON up1.nUnitUID = p.nUUTUnitUID
			LEFT JOIN [dbo].[Units] up2 ON up2.nUnitUID = p.nReferenceUnitUID
			LEFT JOIN [dbo].[Units] up3 ON up3.nUnitUID = p.nCardinalPointUnitUID
			LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upen1 ON upen1.nUnitUID = pen.nField010UnitUID
			LEFT JOIN [dbo].[Units] upen2 ON upen2.nUnitUID = pen.nField029UnitUID
			LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upun1 ON upun1.nUnitUID = pun.nLowerLimitUnitUID
			LEFT JOIN [dbo].[Units] upun2 ON upun2.nUnitUID = pun.nUpperLimitUnitUID
			LEFT JOIN [dbo].[Units] upun3 ON upun3.nUnitUID = pun.nUncertaintyExpandedUnitUID
			LEFT JOIN [dbo].[Units] upun4 ON upun4.nUnitUID = pun.nUncertaintyStandardUnitUID
			LEFT JOIN [dbo].[Units] upun18 ON upun18.nUnitUID = pun.nGuardBandLowerUnitUID
			LEFT JOIN [dbo].[Units] upun19 ON upun19.nUnitUID = pun.nGuardBandUpperUnitUID
			LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] utol1 ON utol1.nUnitUID = tol.nErrorUnitUID
			LEFT JOIN [dbo].[Units] utol5 ON utol5.nUnitUID = tol.nToleranceNegativeUnitUID
			LEFT JOIN [dbo].[Units] utol6 ON utol6.nUnitUID = tol.nTolerancePositiveUnitUID
			LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
			WHERE
				p.lDeleted = 0
			AND
				p.lActive <> 0
		'

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


	PRINT N'Updating database version'
	INSERT INTO [dbo].[Version] (
		[nVersionUID]
		,[cVersion]
		,[tInstallDate]
		,[mNote]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
	  )
	  VALUES
	  (
		'BEAEC660-EEEE-4DDE-BAD1-A4A977CB9A8E'
		,'3.3.0'
		,'20210424 00:57:28.630'
		,'3.3.0 Release'
		,-1
		,0
		,0
		,0
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20210424 00:57:28.630'
		,'DBA97ADF-F868-459D-8343-DE1DF0FFB398'
		,'915F9722-3175-4E4D-A571-4A478E8E5172'
		,'20210424 00:57:28.630'
		,'20210424 00:57:28.630'
		,NULL
	  )

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	-- Make sure previous version records are inactive
	UPDATE [dbo].[Version] SET lActive = 0, tUpdateTime = '20210424 00:57:28.630', tMobileTime = '20210424 00:57:28.630' WHERE lActive <> 0 AND nVersionUID <> 'BEAEC660-EEEE-4DDE-BAD1-A4A977CB9A8E'

	IF EXISTS (SELECT * FROM #tmpErrors) ROLLBACK TRANSACTION

	IF @@TRANCOUNT>0 BEGIN
	PRINT 'The database update succeeded'
	COMMIT TRANSACTION
	END
	ELSE PRINT 'The database update failed'

	DROP TABLE #tmpErrors
END
ELSE
	Print N'The database is up-to-date, version 3.3.0'
GO
